#ifndef SPRITE_H
#define SPRITE_H

#include "allegro.h"
#include "liste.h"
#include "define.h"
#include "SGtimer.h"

// Structure stoquant les donnes utiles pour l'animation du sprite
struct Animation
{
        // Entier indiquant le nombre de direction maximum qu'a le sprite
        int m_iMaxDirec;
        // Entier indiquant le nombre d'animation maximum par direction qu'a le sprite
        int m_iMaxAnim;
        // Entier indiquant en millisecondes la dure d'une animation
        int m_iSpeed;
        // Chaine de caractres dfinissant le nom de l'animation
        char *m_szNomAnim;
        // Entier dfinissant le type de l'animation
        // Soit m_iType est gal  1 et l'animation tourne en boucle
        // Soit m_iType est gal  2 et l'animation ne s'xcute qu'une seule fois
        int m_iType;
        // Tableau d'entier permettant de recaler l'animation en X
        int m_iAjoutX[MAX_DIRECTION];
        // Tableau d'entier permettant de recaler l'animation en Y
        int m_iAjoutY[MAX_DIRECTION];
};

class Sprite
{
    private:
        // Boolen permettant de rendre visible ou non le sprite
        bool m_bVisible;
        // Boolen permettant d'animer ou non le sprite
        bool m_bAnimer;
        // Boolen permettant de rendre transparent le sprite
        bool m_bTransparent;
        // Entier indiquant la direction actuelle du sprite
        int m_iDirection;
        // Entier indiquant l'animation actuelle du sprite
        int m_iAnimation;
        // Entier indiquant l'tat actuel du sprite
        int m_iEtat;
        // Entier indiquant le nombre maximum d'tat du sprite
        int m_iMaxEtat;
        // Tableau de MAX_ETAT cases de la structure animation
        Animation m_Anim[MAX_ETAT];
        // Tableau  3 dimensions definissant toutes les images du sprite
        BITMAP *m_pBmp [MAX_ANIMATION] [MAX_DIRECTION] [MAX_ETAT];
        
        bool m_bCache;
        int m_iXCache,m_iYCache;
    public:
        // Constructeur appelant la procdure initialiser
        Sprite();
        // Destructeur qui s'occupe de dtruire toutes les images stoques dans le
        // tableau de sprites
        ~Sprite();
        // Procdure initialisant les variables  leur tat initial
        // et definissant le tableau de sprite  null
        void initialiser();
        // Procdure qui dfinit l'image m_pBmp[iAnimation][iDirection][iEtat] en chargeant
        // le fichier image de nom szNom prsent dans le rpertoire courant
        void setBmp(char *szNom,const int iAnimation,const int iDirection,const int iEtat);
        // 
        void setBmpEtat(char *szNom, const int iLargeur,const int iHauteur,const int iNbreCol,
                        const int iNbreLigne,const int iEtat);
        bool Visible() const { return m_bVisible ; }
        
        // Definit toutes les images composant l'etat d'un sprite
        // Le 1er argument est le nom de l'image contenant toutes les images de l'animation
        // iLargeur et iHauteur correspondent respectivement  la largeur et la hauteur
        // d'une seule image
        // iNbreCol et iNbreLigne correspondent respectivement au nombre de colonnes et de lignes
        // qu'il y a dans l'image
        // iSpeed est la vitesse en millisecondes de l'animation
        // szNomAnim est le nom de l'animation
        void addBmpEtat(char *szNom, const int iLargeur,const int iHauteur,const int iNbreCol,
                        const int iNbreLigne,const int iSpeed,const int iType,char *szNomAnim);
        // Procdure permettant de changer la valeur du boolen m_bVisible
        void setVisible(const bool bVisible) { m_bVisible=bVisible ; }
        // Procdure qui charge un bitmap dans l'cran virtuel aux coordonnes iX et iY
        void charger(BITMAP **pTemp,const int iX,const int iY);
        // Procdure qui change la valeur de la direction actuelle par iDirection
        void setDirection(const int iDirection);
        // Procdure qui change la valeur de l'animation actuelle par iAnimation
        void setAnimation(const int iAnimation);
        // Procdure qui change la valeur de l'tat actuel par iEtat
        void setEtat(const int iEtat);
        // Procdure qui change la valeur de l'tat actuel par iEtat, bloque l'animation et
        // la remet au dbut
        void changerEtat(const int iEtat);
        // Procdure qui change la valeur du nombre d'tats maximum par iMaxEtat
        void setMaxEtat(const int iMaxEtat);
        // Procdure qui permet de dfinir la vitesse d'un tat
        // iEtat est le numro de l'tat concern
        // iSpeed est la valeur en milliseconde de la vitesse
        // szNom est le nom de l'animation
        void setSpeedAnim(const int iEtat,const int iSpeed,char *szNom);
        // Procdure qui permet de lancer l'animation du sprite
        void animer() { m_bAnimer=true ; }
        // Procdure qui arrte l'animation du sprite
        void stopAnimer() { m_bAnimer=false ; }
        // Procdure qui permet de rendre transparent le sprite
        void transparent() { m_bTransparent=true; }
        // Procdure qui le sprite non transparent
        void nonTransparent() { m_bTransparent=false ;}
        // Fonction qui permet de savoir sur le sprite est transparent ou non
        bool getTransparent() { return m_bTransparent ; }
        // Accesseur qui renvoie la direction actuelle
        int getDirection() const { return m_iDirection ; }
        // Accesseur qui renvoie l'animation actuelle
        int getAnimation() const { return m_iAnimation ; }
        // Accesseur qui renvoie l'tat actuel
        int getEtat() const { return m_iEtat ; }
        // Accesseur qui renvoie le nombre d'tats maximum
        int getMaxEtat() const { return m_iMaxEtat ; }
        // Accesseur qui renvoie true si le sprite s'anime et false sinon
        int getAnimer() const { return m_bAnimer ; }
        // Accesseur retournant la largeur de la 1ere image du tableau de bitmaps
        int getLargeur() const ;
        // Accesseur retournant la hauteur de la 1ere image du tableau de bitmaps
        int getHauteur() const ;
        // Procdure permettant de dcaler l'animation d'un sprite
        // iEtat correspond  l'tat concern
        // iDirection correspond  la direction dans laquelle le dcalage sera effectu
        // iAjoutX et iAjoutY sont les pixels de dcalage en x et y de l'animation
        void setAjoutAnim(const int iEtat,const int iDirection,const int iAjoutX,const int iAjoutY);
        // Fonction retournant true si l'animation est finie et false sinon
        bool animationFinie();
        // Procdure qui permet d'animer un sprite
        // Rem: Elle est appelle par SGAffichage::animerSprites()
        void runAnimer();
        void setCache(const int iX,const int iY);
        
        void changeColor(const int iAnim,const int iDirec,const int iEtat,const int iX,const int iY,const int iColor);
};

#endif
